﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_Applet.h>
#include <nn/friends/friends_AppletForSystemService.h>
#include <nn/friends/friends_AppletPrivateTypes.h>
#include <nn/friends/friends_Result.h>
#include <nn/la/la_Api.h>
#include <nn/util/util_ScopeExit.h>

namespace nn { namespace friends {

namespace {

// CommonArgumentのバージョン指定
const int cMajorVersion = 0;
const int cMinorVersion = 1;

void SetDefaultAppletArg_( AppletArg& arg )
{
    std::memset( &arg, 0, sizeof( AppletArg ) );
}

nn::Result StartMyPageApplet_( nn::applet::LibraryAppletHandle& handle, const AppletArg& appletArg, bool isFromHomeMenu )
{
    // LAを生成する
    NN_ABORT_UNLESS_RESULT_SUCCESS( nn::applet::CreateLibraryApplet(
        &handle,
        nn::applet::AppletId_LibraryAppletMyPage,
        nn::applet::LibraryAppletMode_AllForeground ) );

    // LA共通パラメータをストレージにプッシュする
    nn::la::CommonArgumentsWriter common_arg( cMajorVersion, cMinorVersion );
    common_arg.SetPlayStartupSound( isFromHomeMenu );
    common_arg.PushToInChannel( handle );

    // 引数をプッシュする
    nn::la::PushToInChannel( handle, &appletArg, sizeof( appletArg ) );

    // LA起動
    nn::Result result = nn::la::StartLibraryApplet( handle, false );

    // nn::la での失敗は UIキャンセル扱いにして返す
    if( !result.IsSuccess() ) {
        return nn::friends::ResultAppletCanceled();
    }

    return result;
}

void CloseMyPageApplet_( const nn::applet::LibraryAppletHandle& handle )
{
    nn::applet::CloseLibraryApplet( handle );
}

} // anonymous namespace

nn::Result ShowFriendList( const nn::account::Uid& uid ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowFriendList;
    arg.uid = uid;

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, false );
    CloseMyPageApplet_( handle );
    return result;
}

nn::Result ShowUserDetailInfo( const nn::account::Uid& uid, const nn::account::NetworkServiceAccountId& accountId,
    const InAppScreenName& myInAppScreenName, const InAppScreenName& inAppScreenName ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowDetailInfo;
    arg.uid = uid;
    arg.accountId = accountId;
    std::memcpy( &arg.myInAppScreenName, &myInAppScreenName, sizeof( myInAppScreenName ) );
    std::memcpy( &arg.inAppScreenName, &inAppScreenName, sizeof( inAppScreenName ) );

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, false );
    CloseMyPageApplet_( handle );
    return result;
}

nn::Result StartSendingFriendRequest( const nn::account::Uid& uid, const nn::account::NetworkServiceAccountId& accountId
    , const InAppScreenName& myInAppScreenName, const InAppScreenName& inAppScreenName ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_StartSendingFriendRequest;
    arg.uid = uid;
    arg.accountId = accountId;
    std::memcpy( &arg.myInAppScreenName, &myInAppScreenName, sizeof( myInAppScreenName ) );
    std::memcpy( &arg.inAppScreenName, &inAppScreenName, sizeof( inAppScreenName ) );

    // アプレット起動
    nn::Result result = StartMyPageApplet_( handle, arg, false );

    if( result.IsSuccess() )
    {
        // 正常終了の場合は、アプレットが設定した結果で上書き
        nn::Result my_page_result;
        nn::la::PopFromOutChannel( handle, &my_page_result, sizeof( my_page_result ) );
        result = my_page_result;
    }

    CloseMyPageApplet_( handle );
    return result;
}

nn::Result ShowMethodsOfSendingFriendRequest( const nn::account::Uid& uid ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowMethodsOfSendingFriendRequest;
    arg.uid = uid;

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, false );
    CloseMyPageApplet_( handle );
    return result;
}

nn::Result StartFacedFriendRequest( const nn::account::Uid& uid ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_StartFacedFriendRequest;
    arg.uid = uid;

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, false );
    CloseMyPageApplet_( handle );
    return result;
}

nn::Result ShowReceivedFriendRequestList( const nn::account::Uid& uid ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowReceivedFriendRequestList;
    arg.uid = uid;

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, false );
    CloseMyPageApplet_( handle );
    return result;
}

nn::Result ShowBlockedUserList( const nn::account::Uid& uid ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowBlockedUserList;
    arg.uid = uid;

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, false );
    CloseMyPageApplet_( handle );
    return result;
}

nn::Result ShowMyProfile( const nn::account::Uid& uid ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowMyProfile;
    arg.uid = uid;

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, false );
    CloseMyPageApplet_( handle );
    return result;
}

nn::Result ShowMyProfileForHomeMenu( const nn::account::Uid& uid ) NN_NOEXCEPT
{
    nn::applet::LibraryAppletHandle handle;

    // 起動引数
    AppletArg arg;
    SetDefaultAppletArg_( arg );
    arg.mode = AppletMode_ShowMyProfile;
    arg.uid = uid;

    // マイページアプレットを起動して結果を返す
    nn::Result result = StartMyPageApplet_( handle, arg, true );
    CloseMyPageApplet_( handle );
    return result;
}

}} // namespace nn::friends
