﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_ApiPlayHistory.h>
#include <nn/friends/friends_Result.h>
#include <nn/friends/detail/friends_ApiDetail.h>
#include <nn/friends/detail/friends_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace friends {

nn::Result GetPlayHistoryRegistrationKey(PlayHistoryRegistrationKey* outKey,
    nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outKey);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSyncSession();

    NN_RESULT_DO(session->GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(outKey, accountId, isLocalPlay));

    NN_RESULT_SUCCESS;
}

}}
