﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/json/friends_JsonFileInputStream.h>
#include <nn/friends/friends_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace json {

JsonFileInputStream::JsonFileInputStream() NN_NOEXCEPT :
    m_IsOpened(false),
    m_Position(0)
{
}

JsonFileInputStream::~JsonFileInputStream() NN_NOEXCEPT
{
    if (m_IsOpened)
    {
        Close();
    }
}

nn::Result JsonFileInputStream::Open(const char* path) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(path);

    NN_SDK_ASSERT(!m_IsOpened);

    nn::Result result = nn::fs::OpenFile(&m_Handle, path, nn::fs::OpenMode_Read);

    if (result.IsFailure())
    {
        return result;
    }

    m_IsOpened = true;

    NN_RESULT_SUCCESS;
}

void JsonFileInputStream::Close() NN_NOEXCEPT
{
    if (m_IsOpened)
    {
        nn::fs::CloseFile(m_Handle);
        m_IsOpened = false;
    }
}

nn::Result JsonFileInputStream::FillImpl(size_t* outRead, void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsOpened);

    if (IsCanceled())
    {
        NN_RESULT_THROW(ResultCanceled());
    }

    nn::Result result = nn::fs::ReadFile(outRead, m_Handle, m_Position, buffer, bufferSize);

    if (result.IsFailure())
    {
        return result;
    }

    m_Position += *outRead;

    NN_RESULT_SUCCESS;
}

}}}}}
