﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/json/friends_JsonErrorHandler.h>
#include <nn/friends/friends_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace json {

nn::Result HandleJsonError(RAPIDJSON_NAMESPACE::ParseResult result) NN_NOEXCEPT
{
    if (result)
    {
        NN_RESULT_SUCCESS;
    }

    switch (result.Code())
    {
    case RAPIDJSON_NAMESPACE::kParseErrorDocumentEmpty:
        NN_RESULT_SUCCESS;
    case RAPIDJSON_NAMESPACE::kParseErrorDocumentRootNotSingular:
        NN_RESULT_THROW(ResultJsonDocumentError());
    case RAPIDJSON_NAMESPACE::kParseErrorObjectMissName:
    case RAPIDJSON_NAMESPACE::kParseErrorObjectMissColon:
    case RAPIDJSON_NAMESPACE::kParseErrorObjectMissCommaOrCurlyBracket:
    case RAPIDJSON_NAMESPACE::kParseErrorArrayMissCommaOrSquareBracket:
    case RAPIDJSON_NAMESPACE::kParseErrorStringMissQuotationMark:
    case RAPIDJSON_NAMESPACE::kParseErrorUnspecificSyntaxError:
        NN_RESULT_THROW(ResultJsonSyntaxError());
    case RAPIDJSON_NAMESPACE::kParseErrorValueInvalid:
    case RAPIDJSON_NAMESPACE::kParseErrorStringUnicodeEscapeInvalidHex:
    case RAPIDJSON_NAMESPACE::kParseErrorStringUnicodeSurrogateInvalid:
    case RAPIDJSON_NAMESPACE::kParseErrorStringEscapeInvalid:
    case RAPIDJSON_NAMESPACE::kParseErrorStringInvalidEncoding:
    case RAPIDJSON_NAMESPACE::kParseErrorNumberTooBig:
    case RAPIDJSON_NAMESPACE::kParseErrorNumberMissFraction:
    case RAPIDJSON_NAMESPACE::kParseErrorNumberMissExponent:
        NN_RESULT_THROW(ResultJsonContentError());
    case RAPIDJSON_NAMESPACE::kParseErrorTermination:
        NN_RESULT_THROW(ResultJsonParsingTerminated());
    default:
        NN_RESULT_THROW(ResultJsonSyntaxError());
    }
}

}}}}}
