﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/json/friends_JsonApi.h>
#include <nn/friends/detail/service/json/friends_JsonErrorHandler.h>
#include <nn/friends/detail/service/json/friends_JsonEventHandlerForReader.h>
#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace json {

nn::Result Parse(JsonEventHandler& handler, JsonInputStream& stream,
    const detail::service::util::Cancelable& cancelable) NN_NOEXCEPT
{
    JsonEventHandlerForReader handlerForReader;

    handlerForReader.SetHandler(&handler);
    handlerForReader.SetCancelable(&cancelable);
    handlerForReader.SetOverflowDetector(stream.GetOverflowDetector());

    stream.SetCancelable(&cancelable);

    NullAllocator allocator;

    const unsigned int ParseFlags = RAPIDJSON_NAMESPACE::kParseInsituFlag |
        RAPIDJSON_NAMESPACE::kParseStopWhenDoneFlag | RAPIDJSON_NAMESPACE::kParseValidateEncodingFlag;

    RAPIDJSON_NAMESPACE::ParseResult result = JsonReader(&allocator, 1).Parse<ParseFlags>(stream, handlerForReader);

    if (cancelable.IsCanceled())
    {
        NN_RESULT_THROW(ResultCanceled());
    }

    NN_RESULT_DO(stream.GetLastError());
    NN_RESULT_DO(detail::service::json::HandleJsonError(result));

    NN_RESULT_SUCCESS;
}

}}}}}
