﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskGetFriendRequestCountBase.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerFriendRequestResourceCount.h>
#include <nn/friends/detail/service/core/friends_FriendRequestCountManager.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

nn::Result GetFriendRequestCountBaseTask::StepGetReceivedFriendRequestCount() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetFriendRequestCountBaseTask::StepGetReceivedFriendRequestCount ...\n");

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[512] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/2.0.0/users/%016llx/friend_requests/inbox?&count=100&sort=createdAt:desc&filter.state.$eq=PENDING",
        WebApi::GetFqdn(), accountId.id);

    NN_RESULT_DO(stream.Open("GET", url));

    FriendRequestResourceCountHandler handler;

    NN_RESULT_DO(WebApi::Call(handler, stream, GetUid(), GetCancelable()));

    NN_RESULT_DO(FriendRequestCountManager::GetInstance().SetCount(GetUid(), handler.GetUnreadCount(), handler.GetReadCount()));

    NN_RESULT_SUCCESS;
}

}}}}}
