﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskDeleteFriend.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

DeleteFriendTask::DeleteFriendTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result DeleteFriendTask::SetParameter(nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    m_FriendAccountId = accountId;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result DeleteFriendTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepDelete());
    NN_RESULT_DO(StepSyncFriendList());

    NN_RESULT_SUCCESS;
}

nn::Result DeleteFriendTask::StepDelete() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] DeleteFriendTask::StepDelete ...\n");

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/2.0.0/users/%016llx/friends/%016llx", WebApi::GetFqdn(), accountId.id, m_FriendAccountId.id);

    NN_RESULT_DO(stream.Open("DELETE", url));

    detail::service::json::JsonEventHandler handler;

    bool isNotFriend = false;

    NN_RESULT_TRY(WebApi::Call(handler, stream, GetUid(), GetCancelable()))
        NN_RESULT_CATCH(ResultServerError404ResourceIsNotFound)
        {
            isNotFriend = true;
        }
        NN_RESULT_CATCH(ResultNetworkServiceAccountNotExists)
        {
            isNotFriend = true;
        }
    NN_RESULT_END_TRY;

    // フレンドの削除に成功した場合は StepSyncFriendList で同期される。
    if (isNotFriend)
    {
        // 指定したフレンドがキャッシュ上に存在するかもしれないので削除処理を実行する。
        NN_RESULT_TRY(FriendListManager::GetInstance().DeleteFriend(GetUid(), m_FriendAccountId))
            NN_RESULT_CATCH(ResultNotFriend)
            {
            }
        NN_RESULT_END_TRY;

        NN_RESULT_THROW(ResultNotFriend());
    }

    NN_RESULT_SUCCESS;
}

}}}}}
