﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskClearPlayLog.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerUserResource.h>
#include <nn/friends/detail/service/core/friends_UserSettingManager.h>
#include <nn/friends/detail/service/core/friends_PlayLogManager.h>
#include <nn/friends/detail/service/core/friends_WorkBuffer.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

nn::Result ClearPlayLogTask::Main() NN_NOEXCEPT
{
    // ローカルのキャッシュを削除する。
    NN_RESULT_DO(PlayLogManager::GetInstance().Clear(GetUid()));

    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepClear());

    NN_RESULT_SUCCESS;
}

nn::Result ClearPlayLogTask::StepClear() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] ClearPlayLogTask::StepClear ...\n");

    NN_RESULT_THROW_UNLESS(WorkBuffer::GetInstance().Acquire(GetCancelable()), ResultCanceled());

    NN_UTIL_SCOPE_EXIT
    {
        WorkBuffer::GetInstance().Release();
    };

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/1.0.0/users/%016llx", WebApi::GetFqdn(), accountId.id);

    char patch[512] = {};
    NN_RESULT_DO(CreateClearPatch(patch, sizeof (patch)));

    NN_RESULT_DO(stream.Open("PATCH", url));
    NN_RESULT_DO(stream.AddRequestHeader("Content-Type: application/json-patch+json"));
    NN_RESULT_DO(stream.SetPostField(patch, false));

    UserResourceHandler handler;
    NN_RESULT_DO(handler.Initialize(WorkBuffer::GetInstance().Get(), WorkBuffer::GetInstance().GetSize()));

    NN_RESULT_DO(WebApi::Call(handler, stream, GetUid(), GetCancelable()));

    NN_RESULT_DO(UserSettingManager::GetInstance().Write(GetUid(), handler.GetResource()));

    NN_RESULT_SUCCESS;
}

nn::Result ClearPlayLogTask::CreateClearPatch(char* buffer, size_t size) NN_NOEXCEPT
{
    nn::friends::ExtraPermission playLogPermission;
    NN_RESULT_DO(UserSettingManager::GetInstance().GetPlayLogPermission(&playLogPermission, GetUid()));

    detail::service::json::FixedSizeAllocator allocator;
    detail::service::json::JsonMemoryOutputStream stream;

    stream.Open(buffer, size);
    stream.PutBegin();

    detail::service::json::JsonWriter writer(stream, &allocator, 16);

    detail::service::json::JsonPatchGenerator::BeginWrite(writer);
    {
        detail::service::json::JsonPatchGenerator::BeginWriteAddOperation(writer, "/extras/self/playLog");
        {
            writer.String(playLogPermission == ExtraPermission_Self ? "[]" : "");
        }
        detail::service::json::JsonPatchGenerator::EndWriteAddOperation(writer);
        detail::service::json::JsonPatchGenerator::BeginWriteAddOperation(writer, "/extras/favoriteFriends/playLog");
        {
            writer.String(playLogPermission == ExtraPermission_FavoriteFriends ? "[]" : "");
        }
        detail::service::json::JsonPatchGenerator::EndWriteAddOperation(writer);
        detail::service::json::JsonPatchGenerator::BeginWriteAddOperation(writer, "/extras/friends/playLog");
        {
            writer.String(playLogPermission == ExtraPermission_Friends ? "[]" : "");
        }
        detail::service::json::JsonPatchGenerator::EndWriteAddOperation(writer);
        detail::service::json::JsonPatchGenerator::BeginWriteAddOperation(writer, "/extras/foaf/playLog");
        {
            writer.String(playLogPermission == ExtraPermission_FriendsOfFriend ? "[]" : "");
        }
        detail::service::json::JsonPatchGenerator::EndWriteAddOperation(writer);
        detail::service::json::JsonPatchGenerator::BeginWriteAddOperation(writer, "/extras/everyone/playLog");
        {
            writer.String(playLogPermission == ExtraPermission_Everyone ? "[]" : "");
        }
        detail::service::json::JsonPatchGenerator::EndWriteAddOperation(writer);
    }
    detail::service::json::JsonPatchGenerator::EndWrite(writer);

    stream.PutEnd();
    stream.Close();

    NN_RESULT_SUCCESS;
}

}}}}}
