﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_BgTaskSyncFriendPresence.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerFriendResourceListForPresence.h>
#include <nn/friends/detail/service/core/friends_FriendListManager.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

SyncFriendPresenceBgTask::SyncFriendPresenceBgTask() NN_NOEXCEPT
{
}

nn::Result SyncFriendPresenceBgTask::Main() NN_NOEXCEPT
{
    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepSync());

    NN_RESULT_SUCCESS;
}

nn::Result SyncFriendPresenceBgTask::StepSync() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] SyncFriendPresenceBgTask::StepSync ...\n");

    int count;
    ipc::SizedFriendFilter filter = {};
    ApplicationInfo appInfo = {};

    NN_RESULT_DO(FriendListManager::GetInstance().GetFriendCount(&count, GetUid(), filter, appInfo));

    if (count == 0)
    {
        NN_DETAIL_FRIENDS_INFO("[friends] Friend count = 0. Do nothing.\n");
        NN_RESULT_SUCCESS;
    }

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/2.0.0/users/%016llx/friends?count=%d", WebApi::GetFqdn(), accountId.id, FriendCountMax);

    NN_RESULT_DO(stream.Open("GET", url));

    FriendResourceListForPresenceHandler handler;
    handler.Initialize(GetUid());

    NN_RESULT_DO(WebApi::Call(handler, stream, GetUid(), GetCancelable()));

    NN_RESULT_SUCCESS;
}

}}}}}
