﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_BgTaskGetListSummary.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerFriendResourceListForPresence.h>
#include <nn/friends/detail/service/core/friends_FriendRequestCountManager.h>
#include <nn/friends/detail/service/core/friends_FriendPresenceManager.h>
#include <nn/friends/detail/service/core/friends_OverlayNotificationSender.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

GetListSummaryBgTask::GetListSummaryBgTask() NN_NOEXCEPT
{
}

nn::Result GetListSummaryBgTask::Main() NN_NOEXCEPT
{
    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepSyncFriendList());
    NN_RESULT_DO(StepGetReceivedFriendRequestCount());

    if (Account::IsUserOpened(GetUid()))
    {
        int onlineFriendCount;
        FriendPresenceManager::GetInstance().GetCount(&onlineFriendCount, GetUid(), PresenceStatusFilter_OnlineOrOnlinePlay);

        int unreadFriendRequestCount;
        int readFriendRequestCount;
        NN_RESULT_DO(FriendRequestCountManager::GetInstance().GetCount(&unreadFriendRequestCount, &readFriendRequestCount, GetUid()));

        OverlayNotificationSender::SendListSummaryMessage(GetUid(), static_cast<int32_t>(onlineFriendCount),
            static_cast<int32_t>(unreadFriendRequestCount), static_cast<int32_t>(readFriendRequestCount));
    }
    else
    {
        NN_DETAIL_FRIENDS_INFO("[friends] The user is no longer opened.\n");
    }

    NN_RESULT_SUCCESS;
}

}}}}}
