﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerSnsAccountFriendResourceList.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

SnsAccountFriendResourceListHandler::SnsAccountFriendResourceListHandler() NN_NOEXCEPT :
    m_OutCount(0),
    m_OutFriends(nullptr),
    m_Count(0),
    m_Index(0)
{
}

void SnsAccountFriendResourceListHandler::Initialize(int* outCount, SnsAccountFriendImpl* outFriends,
    int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outFriends);
    NN_SDK_REQUIRES(count > 0);

    m_OutCount = outCount;
    m_OutFriends = outFriends;

    m_Count = count;

    std::memset(m_OutFriends, 0, sizeof (SnsAccountFriendImpl) * m_Count);
}

bool SnsAccountFriendResourceListHandler::OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT
{
    if (jsonPath.Match("$.items[*]"))
    {
        std::memset(&m_Friend, 0, sizeof (m_Friend));
        std::memset(&m_FriendBits, 0, sizeof (m_FriendBits));
    }

    return true;
}

bool SnsAccountFriendResourceListHandler::OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT
{
    NN_UNUSED(numObjects);

    if (jsonPath.Match("$.items[*]"))
    {
        if (m_FriendBits.accountId && m_FriendBits.name1 && m_FriendBits.imageUrl)
        {
            m_Friend.data.isValid = true;

            if (m_Index < m_Count)
            {
                std::memcpy(&m_OutFriends[m_Index], &m_Friend, sizeof (SnsAccountFriendImpl));
                m_Index++;
            }
        }
    }

    return true;
}

bool SnsAccountFriendResourceListHandler::OnEndArray(const detail::service::json::JsonPath& jsonPath, size_t numElements) NN_NOEXCEPT
{
    NN_UNUSED(numElements);

    if (jsonPath.Compare("$.items[]"))
    {
        *m_OutCount = m_Index;
    }

    return true;
}

bool SnsAccountFriendResourceListHandler::OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(isOverflowed);

    if (!m_FriendBits.accountId &&
        jsonPath.Match("$.items[*].id"))
    {
        nn::account::NetworkServiceAccountId accountId;

        if (detail::util::HexToNumber(&accountId.id, value))
        {
            m_Friend.data.accountId = accountId;
            m_FriendBits.accountId = true;
        }
    }
    else if (!m_FriendBits.name1 &&
        jsonPath.Match("$.items[*].*.name"))
    {
        m_FriendBits.name1 = true;

        if (length > 0)
        {
            // コードポイント数の上限は設けない。
            nn::util::CopyUtf8String(m_Friend.data.profile.name1.value,
                sizeof (m_Friend.data.profile.name1.value), value, length, INT_MAX);
        }
    }
    else if (!m_FriendBits.name2 &&
        jsonPath.Match("$.items[*].*.screen_name"))
    {
        m_FriendBits.name2 = true;

        if (length > 0)
        {
            // コードポイント数の上限は設けない。
            nn::util::CopyUtf8String(m_Friend.data.profile.name2.value,
                sizeof (m_Friend.data.profile.name2.value), value, length, INT_MAX);
        }
    }
    else if (!m_FriendBits.imageUrl &&
        jsonPath.Match("$.items[*].*.profile_image_url"))
    {
        m_FriendBits.imageUrl = true;

        // 正しくバッファに収まる場合のみコピーする。
        if (length < sizeof (m_Friend.data.profile.imageUrl.value))
        {
            nn::util::Strlcpy(m_Friend.data.profile.imageUrl.value, value, sizeof (m_Friend.data.profile.imageUrl.value));
        }
    }

    return true;
}

}}}}}
