﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerErrorFrs.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

namespace
{
    struct ErrorTable
    {
        FrsErrorHandler::ErrorInfo info;
        nn::Result result;
    };

    const ErrorTable g_ErrorTable[] =
    {
        {{"0000"}, ResultFriendRecommendServerError0000()},
        {{"0001"}, ResultFriendRecommendServerError0001()},
        {{"0002"}, ResultFriendRecommendServerInvalidIdToken()},
        {{"0003"}, ResultFriendRecommendServerError0003()},
        {{"0004"}, ResultFriendRecommendServerError0004()},
        {{"0005"}, ResultFriendRecommendServerError0005()},
        {{"0006"}, ResultFriendRecommendServerError0006()},
        {{"0007"}, ResultNintendoAccountStatusIsAbnormal()},
        {{"0008"}, ResultFriendRecommendationIsUnavailable()},
        {{"0009"}, ResultFriendRecommendationIsUnavailableToUser()},
        {{"0010"}, ResultFriendRecommendServerError0010()},
        {{"0011"}, ResultFriendRecommendServerError0011()},
        {{"0012"}, ResultFriendRecommendServerError0012()},
        {{"0013"}, ResultNintendoAccountIsNotLinkedToNnid()},
        {{"0014"}, ResultNnidIsNotLinkedTo3Ds()},
        {{"0015"}, ResultFriendRecommendServerError0015()},
        {{"0016"}, ResultNnidStatusIsAbnormal()},
        {{"0017"}, ResultNintendoAccountIsChild()},
        {{"0018"}, ResultSnsAccountIsAlreadyLinkedToOtherNintendoAccount()},
        {{"0019"}, ResultNintendoAccountIsNotLinkedToSnsAccount()},
        {{"0020"}, ResultSnsProfileNotGet()},
        {{"0021"}, ResultFacebookAuthenticationError()},
        {{"0022"}, ResultTwitterAuthenticationError()},
        {{"0023"}, ResultUnexpectedResponseFromFacebook()},
        {{"0024"}, ResultUnexpectedResponseFromTwitter()},
        {{"0025"}, ResultFacebookApiRateLimitExceeded()},
        {{"0026"}, ResultTwitterApiRateLimitExceeded()},
        {{"0027"}, ResultFacebookFriendRecommendationIsUnavailable()},
        {{"0028"}, ResultTwitterFriendRecommendationIsUnavailable()},

        {{}, ResultFriendRecommendServerErrorXxxx()}
    };
}

namespace
{
    nn::Result ConvertServerError(const FrsErrorHandler::ErrorInfo& info) NN_NOEXCEPT
    {
        const ErrorTable* errorTable = g_ErrorTable;

        while (errorTable->info.errorCode[0])
        {
            if (nn::util::Strncmp(errorTable->info.errorCode, info.errorCode, sizeof (info.errorCode)) == 0)
            {
                break;
            }

            errorTable++;
        }

        return errorTable->result;
    }
}

FrsErrorHandler::FrsErrorHandler() NN_NOEXCEPT
{
    m_Info.errorCode[0] = '\0';

    std::memset(&m_Bits, 0, sizeof (m_Bits));
}

nn::Result FrsErrorHandler::GetResult() const NN_NOEXCEPT
{
    if (!m_Bits.errorCode)
    {
        NN_RESULT_THROW(ResultIvalidResponse());
    }

    return ConvertServerError(m_Info);
}

bool FrsErrorHandler::OnString(const detail::service::json::JsonPath& jsonPath,
    const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(length);
    NN_UNUSED(isOverflowed);

    if (!m_Bits.errorCode &&
        jsonPath.Compare("$.errors[0].code"))
    {
        nn::util::Strlcpy(m_Info.errorCode, value, sizeof (m_Info.errorCode));
        m_Bits.errorCode = true;
    }
    else if (!m_Bits.message &&
        jsonPath.Compare("$.errors[0].message"))
    {
        NN_DETAIL_FRIENDS_WARN("[friends] Error: message=%s%s\n", value, isOverflowed ? " ..." : "");
        m_Bits.message = true;
    }

    return true;
}

}}}}}
