﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include "fgm_Log.h"

namespace nn     {
namespace fgm    {
namespace server {

nn::Result Log::Initialize(void* pMemoryIn, size_t memorySize)
NN_NOEXCEPT
{
    return Cbuf::Initialize(reinterpret_cast<DebugEntry*>(pMemoryIn), memorySize / sizeof(DebugEntry));
}

nn::Result Log::Finalize()
NN_NOEXCEPT
{
    return Cbuf::Finalize();
}

nn::Result Log::Read(DebugEntry* pEntriesOut, uint32_t toRead, uint32_t* pReadOut, uint32_t* pLostOut, uint32_t* pRemainingOut)
NN_NOEXCEPT
{
    uint32_t count;

    for (count = 0; count < toRead; count++)
    {
        if (CbufRead(pEntriesOut++) == 0)
        {
            break;
        }
    }

    *pReadOut      = count;
    *pLostOut      = CbufLost();
    *pRemainingOut = CbufRemaining();

    return ResultSuccess();
}

nn::Result Log::Write(DebugEntry* pEntryIn)
NN_NOEXCEPT
{
    CbufWrite(pEntryIn);
    return ResultSuccess();
}

}}}
