﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fgm/fgm_Types.h>

#include "../fgm_Resource.h"

namespace nn     {
namespace fgm    {
namespace server {
namespace detail {

class TestResource : private Resource
{
private:
    Setting m_Current;

public:
    nn::Result Set(Setting min, Setting max)
    NN_NOEXCEPT
    {
        m_Current = min;
        return ResultSuccess();
    }

    nn::Result Get(Setting* current)
    NN_NOEXCEPT
    {
        *current = m_Current;
        return ResultSuccess();
    }

    explicit TestResource(Module fgmId)
    NN_NOEXCEPT :
        Resource(fgmId)
    {

    }

    nn::Result Initialize()
    {
        return Resource::Initialize(Setting_Min, Setting_Max);
    }
};

}}}}

