﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/fatal/detail/fatal_Log.h>
#include <nne/audio/audio_Codec.h>
#include "fatalsrv_Sound.h"

namespace nn { namespace fatalsrv {
    namespace
    {
        Result StopSoundAll() NN_NOEXCEPT
        {
            NN_DETAIL_FATAL_TRACE("StopSoundAll\n");

            // コーデック IC の電源は Ape のクロックより前にオフ
            // TODO: Copper の時は呼び出さないようにする
            nne::audio::codec::Abort();

            NN_RESULT_SUCCESS;
        }

        class StopSoundAllTask : public ITask
        {
        public:
            virtual Result Run() NN_NOEXCEPT
            {
                NN_RESULT_DO(StopSoundAll());
                NN_RESULT_SUCCESS;
            }
            virtual const char* GetTaskName() const {
                return "SoundTask";
            }
        };

        StopSoundAllTask g_Task;
    }

    ITask* InitializeAndGetSoundTask() NN_NOEXCEPT
    {
        return &g_Task;
    }
}} // namespace nn::fatalsrv
