﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEventTypes.h>
#include <nn/os/os_MultipleWaitUtility.h>

namespace nn { namespace fatalsrv {
    class SettingsEventManager {
    public:
        SettingsEventManager() NN_NOEXCEPT :
            m_Initialized(false), m_Event({}), m_MultiWaitHolder({})
        {}
        nn::os::MultiWaitHolderType* GetEventWaitHolder() NN_NOEXCEPT;
        void OnSettingsUpdated() NN_NOEXCEPT;
    private:
        bool m_Initialized;
        nn::os::SystemEventType m_Event;
        nn::os::MultiWaitHolderType m_MultiWaitHolder;
    };
}} //namespace nn::fatalsrv
