﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/fatal/detail/fatal_Log.h>
#include "fatalsrv_Screen.h"

namespace nn { namespace fatalsrv {
    ITask* InitializeAndGetBacklightControlTask() NN_NOEXCEPT
    {
        NN_DETAIL_FATAL_WARN("BacklightControlTask is not supported on windows\n");
        return nullptr;
    }

    ITask* InitializeAndGetFatalScreenTask(const Service::Context&, nn::Bit64, nn::os::Event*) NN_NOEXCEPT
    {
        NN_DETAIL_FATAL_WARN("FatalScreenTask is not supported on windows\n");
        return nullptr;
    }
}} // namespace nn::fatalsrv
