﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bpc/bpc_PowerButtonTypes.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Event.h>
#include <nn/psm/psm_SystemProcess.h>

#include "fatalsrv_Task.h"

namespace nn { namespace fatalsrv {
    class IPowerController
    {
    public:
        virtual void Shutdown() NN_NOEXCEPT = 0;
        virtual void Reboot() NN_NOEXCEPT = 0;
        virtual nn::psm::BatteryVoltageState GetBatteryVoltageState() NN_NOEXCEPT = 0;
        virtual nn::bpc::SleepButtonState GetSleepButtonState() NN_NOEXCEPT = 0;
        virtual int GetMaxShutdownWaitSec() const NN_NOEXCEPT = 0;
    };

    class PowerControlTask : public ITask
    {
    public:
        PowerControlTask() NN_NOEXCEPT : m_ErrorReportWrittenEvent(nullptr), m_BatteryCheckedEvent(nullptr), m_pPowerController(nullptr) {}
        void Initialize(nn::os::Event* errorReportWrittenEvent, nn::os::Event* batteryCheckedEvent) NN_NOEXCEPT;
        void Initialize(nn::os::Event* errorReportWrittenEvent, nn::os::Event* batteryCheckedEvent, IPowerController* powerController) NN_NOEXCEPT;
        virtual Result Run() NN_NOEXCEPT;
        virtual const char* GetTaskName() const NN_NOEXCEPT;

    private:
        void ObserveBatteryPower() NN_NOEXCEPT;
        nn::os::Event* m_ErrorReportWrittenEvent;
        nn::os::Event* m_BatteryCheckedEvent;
        IPowerController* m_pPowerController;
    };

    class PowerButtonObserveTask : public ITask
    {
    public:
        PowerButtonObserveTask() NN_NOEXCEPT : m_ErrorReportWrittenEvent(nullptr), m_pPowerController(nullptr)
        {}

        void Initialize(nn::os::Event* errorReportWrittenEvent) NN_NOEXCEPT;
        void Initialize(nn::os::Event* errorReportWrittenEvent, IPowerController* powerController) NN_NOEXCEPT;
        virtual Result Run() NN_NOEXCEPT;
        virtual const char* GetTaskName() const NN_NOEXCEPT;

    private:
        void ObservePowerButton() NN_NOEXCEPT;
        nn::os::Event* m_ErrorReportWrittenEvent;
        IPowerController* m_pPowerController;
    };

    ITask* InitializeAndGetStateTransitionStopTask() NN_NOEXCEPT;
    ITask* InitializeAndGetPowerButtonTask(nn::os::Event* errorReportWrittenEvent) NN_NOEXCEPT;
    ITask* InitializeAndGetPowerControlTask(nn::os::Event* errorReportWrittenEvent, nn::os::Event* batteryCheckedEvent) NN_NOEXCEPT;

}} //namespace nn::fatalsrv
