﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fatal/detail/fatal_Log.h>
#include <nn/result/result_HandlingUtility.h>

#include "fatalsrv_PowerControl.h"

namespace nn { namespace fatalsrv {
    // INFO: PC 版は空実装
    namespace {
        class DummyPowerController : public IPowerController
        {
            virtual void Shutdown() NN_NOEXCEPT {}
            virtual void Reboot() NN_NOEXCEPT {}
            virtual nn::psm::BatteryVoltageState GetBatteryVoltageState() NN_NOEXCEPT { return nn::psm::BatteryVoltageState::BatteryVoltageState_Good; }
            virtual nn::bpc::SleepButtonState GetSleepButtonState() NN_NOEXCEPT { return nn::bpc::SleepButtonState::SleepButtonState_Released; }
            virtual int GetMaxShutdownWaitSec() const NN_NOEXCEPT { return 0; }
        };

        DummyPowerController s_DefaultPowerController;
    }

    void PowerButtonObserveTask::ObservePowerButton() NN_NOEXCEPT {}

    ITask* InitializeAndGetStateTransitionStopTask() NN_NOEXCEPT
    {
        NN_DETAIL_FATAL_WARN("StateTransitionStopTask is not supported on windows\n");
        return nullptr;
    }

    ITask* InitializeAndGetPowerButtonTask(nn::os::Event*) NN_NOEXCEPT
    {
        NN_DETAIL_FATAL_WARN("PowerButtonTask is not supported on windows\n");
        return nullptr;
    }

    ITask* InitializeAndGetPowerControlTask(nn::os::Event*, nn::os::Event*) NN_NOEXCEPT
    {
        NN_DETAIL_FATAL_WARN("PowerControlTask is not supported on windows\n");
        return nullptr;
    }
}} // namespace nn::fatalsrv
