﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_BitTypes.h>
#include <nn/fatalsrv/fatalsrv_FatalContext.h>
#include <nn/fatalsrv/fatalsrv_CpuContext.h>
#include <nn/fatalsrv/fatalsrv_Service.h>
#include <nn/err/err_Api.h>
#include <nn/ncm/ncm_ProgramId.h>

#include "fatalsrv_Task.h"

namespace nn { namespace fatalsrv {
    Result WriteErrorReport(const fatalsrv::FatalContext& fatalContext, const fatalsrv::CpuContext& cpuContext, Bit64 programId) NN_NOEXCEPT;
    nn::err::ErrorCode CreateErrorCodeFromResult(const Result& result) NN_NOEXCEPT;

    ITask* InitializeAndGetErrorReportTask(const Service::Context& context, Bit64 id, bool needsErrorReport, nn::os::Event* writtenEvent) NN_NOEXCEPT;

}} //namespace nn::fatalsrv
