﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/settings/system/settings_SerialNumber.h>
#include <nn/settings/system/settings_Language.h>

namespace nn { namespace fatalsrv {
    struct EnvironmentInfo
    {
        nn::settings::system::SerialNumber serialNumber;
        nn::settings::system::FirmwareVersion firmwareVersion;
        nn::settings::LanguageCode languageCode;
        bool transitionToFatal;
        bool showExtraInfo;
        bool questFlag;
        int32_t questRebootIntervalSecond;
    };

    void InitializeEnvironmentInfo() NN_NOEXCEPT;
    void UpdateLanguageCode() NN_NOEXCEPT;
    const EnvironmentInfo& GetEnvironmentInfo() NN_NOEXCEPT;
}} //namespace nn::fatalsrv
