﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/diag_AbortObserver.h>
#include <nn/diag/diag_AbortObserverForSystem.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/fatal/detail/fatal_Log.h>
#include <nn/fatalsrv/fatalsrv_AbortObserver.h>
#include <nn/os/os_Event.h>

#include "fatalsrv_ThreadContextAccessor.h"

namespace nn { namespace fatalsrv {
    namespace
    {
        diag::SdkAbortObserverHolder g_AbortObserverHolder;

        // 特定のモジュールの不具合に引きずられて Fatal の全機能が止まることを防ぐために
        // Fatal プロセスがアボートした場合、それがタスクスレッドからのアボートであれば
        // Observer 内で無限待ちを行い、Fatal プロセスが break することを防ぐ
        void FatalProcessAbortObserver(const diag::SdkAbortInfo& abortInfo) NN_NOEXCEPT
        {
#if defined(NN_SDK_BUILD_RELEASE)
            NN_UNUSED(abortInfo);
#endif
            if (GetDefaultThreadContextAccessor()->IsTaskThread())
            {
                NN_DETAIL_FATAL_ERROR("Abort occured on fatal task thread.\n");
                NN_DETAIL_FATAL_ERROR("File: %s\n", abortInfo.abortInfo.fileName);
                NN_DETAIL_FATAL_ERROR("Line: %d\n", abortInfo.abortInfo.lineNumber);
                NN_DETAIL_FATAL_ERROR("This thread will be sleep infinity.\n");

                os::Event neverSignaledEvent(os::EventClearMode_ManualClear);
                neverSignaledEvent.Wait();
            }
        }
    } // namespace

    void InitializeAbortObserver() NN_NOEXCEPT
    {
        diag::InitializeSdkAbortObserverHolder(&g_AbortObserverHolder, FatalProcessAbortObserver);
        diag::RegisterSdkAbortObserver(&g_AbortObserverHolder);
    }
}} // namespace nn::fatalsrv
