﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.fan
{
    [CppRefPath("<nn/fan/fan_ControlTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct RotationSpeedLevel
    {
    }
}

namespace nn.fan.detail
{
    // 実操作を担当する FAN のセッションオブジェクト。
    // セッションの取得は Manager で行う。
    [CppRefPath("<nn/fan/detail/fan_IController.h>")]
    interface IController : IServiceObject
    {
        [MethodId(0)]
        Result SetRotationSpeedLevel(RotationSpeedLevel level);

        [MethodId(1)]
        Result SetRotationSpeedLevelByDiff(Out<RotationSpeedLevel> newLevel, RotationSpeedLevel levelDiff);

        [MethodId(2)]
        Result GetRotationSpeedLevel(Out<RotationSpeedLevel> level);

        [MethodId(3)]
        Result SetRotationRate(int_t rotationRate);

        [MethodId(4)]
        Result GetRotationRate(Out<int_t> rotationRate);

        [MethodId(5)]
        Result EnableFan();

        [MethodId(6)]
        Result DisableFan();

        [MethodId(7)]
        Result GetActualRotationSpeedLevel(Out<RotationSpeedLevel> level);
    }

    // チャンネルごとの FAN 制御セッションを返すマネージャークラス
    [CppRefPath("<nn/fan/detail/fan_IManager.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenController(Out<IController> outSession, int32_t name);
    }
}
