﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/nn_Common.h>

#include <nn/fan/fan_ControlTypes.h>
#include "fan_ControllerImpl.h"
#include "fan_ControllerResourceManager.h"
#include "fan_DeviceAccessor.h"

namespace nn {
namespace fan {
namespace impl {
namespace detail {

ControllerImpl::ControllerImpl(ControllerHolder *pControllerHolder, FanName name) NN_NOEXCEPT :
    m_pControllerHolder(pControllerHolder),
    m_pDeviceAccessor(nullptr)
{
    // 構築済みの DeviceAccessor オブジェクトへのポインタをセット
    m_pDeviceAccessor = static_cast<DeviceAccessor*>(m_pControllerHolder->GetDeviceAccessorHolder());
}

} // detail
} // impl
} // fan
} // nn
