﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.erpt
{
    [ExternalStruct(20, 4)]
    [CppRefPath(@"<nn/erpt/erpt_Types.h>")]
    public struct ReportId
    {
    }
}

namespace nn.eupld.sf
{
    [CppRefPath(@"<nn/eupld/sfdl/eupld.sfdl.h>")]
    public interface IRequest : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<NativeHandle> handleOut);

        [MethodId(1)]
        Result UploadAll();

        [MethodId(2)]
        Result UploadSelected(nn.sf.InBuffer reportIdArray);

        [MethodId(3)]
        Result GetUploadStatus(nn.sf.OutBuffer uploadStatus);

        [MethodId(4)]
        Result CancelUpload();

        [MethodId(5)]
        Result GetResult();
    }

    [CppRefPath(@"<nn/eupld/sfdl/eupld.sfdl.h>")]
    public interface IControl : IServiceObject
    {
        [MethodId(0)]
        Result SetUrl(nn.sf.InBuffer urlString);

        [MethodId(1)]
        Result ImportCrt(nn.sf.InBuffer crt);

        [MethodId(2)]
        Result ImportPki(nn.sf.InBuffer pki, nn.sf.InBuffer password);

        [MethodId(3)]
        Result SetAutoUpload(bool enable, uint32_t flagValidTimeSeconds);

        [MethodId(4)]
        Result GetAutoUpload(nn.sf.Out<bool> pOutAudoUpload, nn.sf.Out<uint32_t> pOutFlagValidTimeSeconds);
    }
}
