﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dauth/dauth_Api.h>
#include <nn/os.h>
#include <nn/socket.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/ssl.h>
#include <curl/curl.h>
#include <nn/eupld/eupld_Control.h>

namespace nn    {
namespace eupld {
namespace srv   {

class Request;

const uint32_t MaxEnvironmentLength = 16;
const int      TcpSocketCount       = 2;

class Transport
{
private:
    static char         m_Url[MaxUrlLength];
    static bool         m_UrlSet;
    static char         m_Environment[MaxEnvironmentLength];
    static bool         m_TransportEnabled;

    static nn::socket::SystemConfigLightDefaultWithMemory<TcpSocketCount, 0>
                        m_SocketConfiguration;

    static nn::Result UploadReports(Request* pRequest)
    NN_NOEXCEPT;

    static nn::Result SetupCurlHandle(CURL* pCurlHandleIn)
    NN_NOEXCEPT;

public:
    static nn::Result Upload(Request* pRequest)
    NN_NOEXCEPT;

    static nn::Result SetEnvironmentId()
    NN_NOEXCEPT;

    static nn::Result SetUrl(const char* pUrlString, uint32_t urlLength)
    NN_NOEXCEPT;

    static void TransportControl(bool enable)
    NN_NOEXCEPT;

    static bool IsTransportEnabled()
    NN_NOEXCEPT;
};

}}}
