﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/eupld/eupld_Control.h>
#include <nn/eupld/sfdl/eupld.sfdl.h>

#include "eupld_Session.h"

namespace nn    {
namespace eupld {

nn::Result Control::SetUrl(const char* pUrlString, uint32_t urlLength)
NN_NOEXCEPT
{
    nn::Result result;

    nn::sf::SharedPointer<sf::IControl> pImpl;
    nn::sf::InBuffer urlString(pUrlString, urlLength);

    if ((result = GetControlObject(&pImpl)).IsSuccess())
    {
        result = pImpl->SetUrl(urlString);
        pImpl  = nullptr;
    }

    return result;
}

nn::Result Control::ImportCrt(const char* pCrtBuffer, uint32_t crtBufferLength)
NN_NOEXCEPT
{
    nn::Result result;

    nn::sf::SharedPointer<sf::IControl> pImpl;
    nn::sf::InBuffer crtBuffer(pCrtBuffer, crtBufferLength);

    if ((result = GetControlObject(&pImpl)).IsSuccess())
    {
        result = pImpl->ImportCrt(crtBuffer);
        pImpl  = nullptr;
    }

    return result;
}

nn::Result Control::ImportPki(const char* pPkiBuffer, uint32_t pkiBufferLength, const char* pPassword, uint32_t passwordLength)
NN_NOEXCEPT
{
    nn::Result result;

    nn::sf::SharedPointer<sf::IControl> pImpl;
    nn::sf::InBuffer pki(pPkiBuffer, pkiBufferLength);
    nn::sf::InBuffer password(pPassword, passwordLength);

    if ((result = GetControlObject(&pImpl)).IsSuccess())
    {
        result = pImpl->ImportPki(pki, password);
        pImpl  = nullptr;
    }

    return result;
}

nn::Result Control::SetAutoUpload(bool enable, uint32_t flagValidTimeSeconds)
NN_NOEXCEPT
{
    nn::Result result;

    nn::sf::SharedPointer<sf::IControl> pImpl;

    if ((result = GetControlObject(&pImpl)).IsSuccess())
    {
        result = pImpl->SetAutoUpload(enable, flagValidTimeSeconds);
        pImpl  = nullptr;
    }

    return result;
}

nn::Result Control::GetAutoUpload(bool* pOutIsEnabled, uint32_t* pOutValidTimeSeconds)
NN_NOEXCEPT
{
    nn::Result result;

    nn::sf::SharedPointer<sf::IControl> pImpl;

    if ((result = GetControlObject(&pImpl)).IsSuccess())
    {
        result = pImpl->GetAutoUpload(pOutIsEnabled, pOutValidTimeSeconds);
        pImpl = nullptr;
    }

    return result;
}

}}
