﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include "es_ELicenseList.h"
#include "es_ELicenseArchiveAdaptor.h"
#include "es_ELicenseArchiveStore.h"
#include "es_ELicenseImportContext.h"
#include "json/es_RapidJson.h"

namespace nn { namespace es {

struct ELicenseChallengeManager
{
public:
    ELicenseImportContext::Challenge GenerateChallenge(ELicenseOwnerId ownerId) NN_NOEXCEPT;
    Result VerifyChallenge(ELicenseOwnerId ownerId, ELicenseImportContext::Challenge challenge) const NN_NOEXCEPT;

private:
    bool IsStillValid() const NN_NOEXCEPT;

    ELicenseImportContext::Challenge    m_Challenge;
    ELicenseOwnerId                     m_OwnerId;
    os::Tick                            m_ExpireDate;
};

class ELicenseManager
{
public:
    ELicenseManager(ELicenseArchiveStore* pELicenseArchiveStore, ELicenseList* pELicenseList) NN_NOEXCEPT
        : m_pStore(pELicenseArchiveStore), m_pList(pELicenseList)
    {
    };

    nn::Result BeginImportELicenseArchive(ELicenseImportContext* outContext, ELicenseOwnerId ownerId) NN_NOEXCEPT;
    nn::Result ImportELicenseArchive(const ELicenseImportContext& context, const void* eLicenseArchiveBuffer, size_t eLicenseArchiveSize) NN_NOEXCEPT;
    nn::Result EndImportELicenseArchive(ELicenseArchiveId* outELicenseArchiveId, const ELicenseImportContext& context) NN_NOEXCEPT;
    nn::Result EndImportELicenseArchiveForDebug(ELicenseArchiveId* outELicenseArchiveId, const ELicenseImportContext& context) NN_NOEXCEPT;
    nn::Result GetELicenseArchiveSizeForDebug(uint64_t* outSize, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
    nn::Result GetELicenseArchiveDataForDebug(uint64_t* outSize, void* outELicenseArchiveBuffer, size_t eLicenseArchiveBufferSize, nn::es::ELicenseOwnerId ownerId) NN_NOEXCEPT;
    nn::Result DeleteAllELicenseArchiveForDebug() NN_NOEXCEPT;

    nn::Result ReadAllSavedELicenseArchive() NN_NOEXCEPT;
private:
    nn::Result ReadELicenseArchive(ELicenseArchiveId* outELicenseArchiveId, ELicenseOwnerId ownerId, bool readAfterReboot, bool isDebug) NN_NOEXCEPT;
    template <typename StreamType>
    Result ParseELicenseArchive(ELicenseArchiveId* outELicenseArchiveId, ELicenseArchiveAdaptor& adaptor, StreamType& stream, ELicenseOwnerId ownerId, bool verifyChallenge) NN_NOEXCEPT;

    json::ELicenseArchiveFileStreamForRapidJson m_ELicenseArchiveFileStream;

    static const int FileReadBufferSize = 256;
    json::FileStreamForRapidJson<FileReadBufferSize> m_ELicenseArchiveFileStreamForDebug;
    static const int StringBufferSize = 128;
    char m_StringBuffer[StringBufferSize];

    ELicenseArchiveStore* m_pStore;
    ELicenseList* m_pList;

    ELicenseChallengeManager m_ChallengeManager;
};

}} // namespace nn::es
