﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/es/es_TypesForInner.h>

namespace nn { namespace es {

class ELicenseImportContextAccessor
{
public:
    explicit ELicenseImportContextAccessor(ELicenseImportContext* pContext) NN_NOEXCEPT
        : m_pContext(pContext)
    {
    }

    void SetELicenseOwnerId(ELicenseOwnerId ownerId) NN_NOEXCEPT
    {
        m_pContext->_data[static_cast<std::underlying_type<Offset>::type>(Offset::ELicenseOwnerId)] = ownerId.id;
    }

    void SetChallenge(ELicenseImportContext::Challenge challenge) NN_NOEXCEPT
    {
        m_pContext->_data[static_cast<std::underlying_type<Offset>::type>(Offset::Challenge)] = challenge.value;
    }

    static ELicenseOwnerId GetELicenseOwnerId(const ELicenseImportContext& context) NN_NOEXCEPT
    {
        return { context._data[static_cast<std::underlying_type<Offset>::type>(Offset::ELicenseOwnerId)] };
    }

    static uint64_t GetChallenge(const ELicenseImportContext& context) NN_NOEXCEPT
    {
        return context._data[static_cast<std::underlying_type<Offset>::type>(Offset::Challenge)];
    }

private:
    // ELicenseImportContext の _data が持つ情報のオフセット
    enum class Offset : uint8_t
    {
        ELicenseOwnerId     = 0,
        Challenge           = 1,
    };

    ELicenseImportContext* m_pContext;
};

}} // namespace nn::es
