﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/es/es_ELicenseApi.h>
#include <nn/http/json/http_JsonPath.h>
#include <nn/http/json/http_JsonErrorMap.h>
#include <nn/http/json/http_RapidJsonApi.h>
#include <nn/http/json/http_RapidJsonInputStream.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_Optional.h>
#include <nn/util/util_StringUtil.h>
#include "json/es_AdaptorBase.h"
#include "es_ELicenseList.h"

#include <nn/nn_SdkLog.h>

namespace nn { namespace es {

namespace
{
    const int AdapterDepth = 8;
    const int AdapterLength = 128;
}

class ELicenseArchiveAdaptor : public json::AdaptorBase<AdapterDepth, AdapterLength>
{
public:
    ELicenseArchiveAdaptor(ELicenseOwnerId ownerId, ELicenseList* list, bool readAfterReboot) NN_NOEXCEPT
        : m_DeclaredELicenseOwnerId(ownerId), m_pList(list), m_ReadAfterReboot(readAfterReboot)
    {
    }

    virtual Result UpdateImpl(const JsonPathType& path, const char* pValue, int length) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result UpdateImpl(const JsonPathType& path, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result UpdateImpl(const JsonPathType& path, int64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result UpdateImpl(const JsonPathType& path, uint64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result NotifyObjectBeginImpl(const JsonPathType& path) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result NotifyObjectEndImpl(const JsonPathType& path) NN_NOEXCEPT NN_OVERRIDE;

    util::optional<ELicenseImportContext::Challenge> GetChallenge() NN_NOEXCEPT
    {
        return m_Challenge;
    }

    util::optional<ELicenseOwnerId> GetELicenseOwnerId() NN_NOEXCEPT
    {
        return m_ELicenseOwnerId;
    }

    util::optional<ELicenseArchiveId> GetELicenseArchiveId() NN_NOEXCEPT
    {
        return m_ELicenseArchiveId;
    }

    util::optional<uint64_t> GetPublishAt() NN_NOEXCEPT
    {
        return m_PublishDate;
    }

private:
    char m_Path[AdapterLength];
    int m_CurrentIndex = -1;

    util::optional<ELicenseInfoForSystem> m_ELicense;
    util::optional<ELicenseImportContext::Challenge> m_Challenge;
    util::optional<ELicenseOwnerId> m_ELicenseOwnerId;
    util::optional<ELicenseArchiveId> m_ELicenseArchiveId;
    util::optional<uint64_t> m_PublishDate;

    ELicenseOwnerId m_DeclaredELicenseOwnerId;
    ELicenseList* m_pList;
    bool m_ReadAfterReboot;

    const char* GetNextELicensePath() NN_NOEXCEPT;
    const char* GetCurrentELicensePath() NN_NOEXCEPT;
    const char* GetCurrentELicensePath(const char* key) NN_NOEXCEPT;
};

}} // namespace nn::es
