﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/es/es_IETicketService.sfdl.h>      // for IETicketService
#include <nn/sf/sf_HipcClientProxyByName.h>     // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>          // for nn::sf::ExpHeapStaticAllocator
#include "es_ServiceName.h"                     // for ETicketServiceName
#include "es_CreateETicketService.h"

namespace nn { namespace es {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備します。
struct CreateETicketServiceByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateETicketServiceByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:
    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<IETicketService> CreateETicketServiceByHipc() NN_NOEXCEPT
{
    // ETicketServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IETicketService としてプロキシクライアントを作成して返します。
    // アロケーションポリシーとして MyAllocator::Policy を渡します。
    nn::sf::SharedPointer<IETicketService> ret;
    auto result = nn::sf::CreateHipcProxyByName<IETicketService, MyAllocator::Policy>(&ret, ETicketServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    return ret;
}

}}  // namespace nn::es
