﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/os/os_Tick.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/time/time_PosixTime.h>
#include <nn/es/es_RightsTypes.h>
#include <nn/es/es_ELicenseTypes.h>
#include <nn/es/es_TypesForInner.h>
#include <nn/es/es_ActiveRightsContextTypes.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_NativeHandle.h>

#include "es_UsingRightsArray.h"

namespace nn { namespace es {

class ETicketServiceImpl;
class RightsAvailabilityMaster;

// アプリ権利リストを保持するインスタンス
class ActiveRightsContext
{
    friend RightsAvailabilityMaster;

public:
    explicit ActiveRightsContext(ETicketServiceImpl* pETicketServiceImpl) NN_NOEXCEPT;
    ~ActiveRightsContext() NN_NOEXCEPT;

    Result SetUsersOfAccountRestrictedRights(sf::InArray<es::ELicenseUserId> userIdList, bool anyAccount) NN_NOEXCEPT;
    Result GetUsersOfAccountRestrictedRights(sf::Out<int> pOutCount, sf::OutArray<ELicenseUserId> outList) NN_NOEXCEPT;

    Result RegisterRightsIdList(sf::InArray<es::RightsId> rightsIdList) NN_NOEXCEPT;
    Result CheckRightsIdListValidity() NN_NOEXCEPT;
    Result RemoveUnavailableRightsIds() NN_NOEXCEPT;
    Result ListUsingRightsIds(sf::Out<int> outCount, sf::OutArray<RightsId> outList, bool isTemporaryOnly) NN_NOEXCEPT;
    Result ListUsingELicenseIds(sf::Out<int> pOutCount, sf::OutArray<ELicenseId> outList, bool isTemporaryOnly, ELicenseOwnerId ownerId) NN_NOEXCEPT;
    Result ListUsingELicenseOwnerIds(sf::Out<int> pOutCount, sf::OutArray<ELicenseOwnerId> outList) NN_NOEXCEPT;
    Result BeginUsingActiveRightsContext() NN_NOEXCEPT;
    Result EndUsingActiveRightsContext() NN_NOEXCEPT;
    Result ForceActivateRightsContextForExit() NN_NOEXCEPT;
    Result GetActiveRightsContextStatus(sf::Out<int> pOutStatus) NN_NOEXCEPT;
    Result GetActiveRightsContextExpiredTime(sf::Out<int64_t> pOutExpiredTime) NN_NOEXCEPT;
    Result GetActiveRightsContextExpiredTimeChangedEvent(sf::Out<sf::NativeHandle> pOut) NN_NOEXCEPT;

private:
    int GetActiveRightsContextStatusImpl() NN_NOEXCEPT;
    bool IsValidRightsIdListed(const RightsId& rightsId) NN_NOEXCEPT;

    os::Tick GetExpiredTickMax() const NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_ExpiredTickMax.GetInt64Value() != 0ull);
        return m_ExpiredTickMax;
    }

private:
    ETicketServiceImpl* m_pETicketServiceImpl;

    // 権利リスト
    UsingRightsArray* m_pUsingRightsArray = nullptr;

    // アカウント限定権利の利用者リスト（m_IsAnyAccount == false 時に使用）
    ELicenseUserId m_UserIdList[ELicenseUserCountMax];

    // コンテキスト毎に 1 つだけ保持すればよいもの ---------------------------
    os::Tick m_ExpiredTickMax = os::Tick(0);
    os::Tick m_ExpiredTick = os::Tick(0);
    os::SdkMutex m_Mutex;

    bool m_IsAnyAccount = true;
    uint8_t m_ELicenseUserCount = 0;
    bool m_IsFirstActivationDone = false;
    bool m_IsActive = false;
    bool m_IsForceActivatedForExit = false;
    util::optional<bool> m_pIsAllRightsIdsCheckedAndValid = util::nullopt;
    os::SystemEvent m_StateChangedEvent{os::EventClearMode_ManualClear, true};
};

}}
