﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/erpt.h>

namespace nn { namespace err { namespace detail {

Bit64 GetReportApplicationIdValue() NN_NOEXCEPT;

void SubmitApplicationInfo(void* workBuffer, size_t workBufferSize) NN_NOEXCEPT;
void ClearApplicationInfo() NN_NOEXCEPT;

/**
* @brief        入力チャンネルから ResultBacktrace を読み込んで erpt::Context に書き込みます。
* @param[out]   pOutValue ResultBacktrace を書き込む erpt::Context
* @param[in]    workBuffer ワークバッファ
* @param[in]    workBufferSize ワークバッファのサイズ
* @pre
*               - pOutValue の CategoryId が ErrorInfo
*               - workBufferSize >= sizeof(ResultBacktrace) + sizeof(uint32_t) * ResultBacktrace::CountMax
*/
void AddResultBacktrace(erpt::Context* pOutValue, void* workBuffer, size_t workBufferSize) NN_NOEXCEPT;

/**
* @brief        入力チャンネルから ErrorContext を読み込んで erpt::Context に書き込みます。
* @param[out]   pOutValue ErrorContext を書き込む erpt::Context
* @param[in]    workBuffer ワークバッファ
* @param[in]    workBufferSize ワークバッファのサイズ
* @pre
*               - pOutValue の CategoryId が ErrorInfo
*               - workBufferSize >= sizeof(ErrorContext)
*/
void AddErrorContext(erpt::Context* pOutValue, void* workBuffer, size_t workBufferSize) NN_NOEXCEPT;

}}}
