﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/erpt.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/err/err_SystemTypes.h>

namespace nn { namespace err { namespace detail {

void SubmitFileSystemInfo() NN_NOEXCEPT;
void ClearFileSystemInfo() NN_NOEXCEPT;

void SubmitApplicationId(nn::ApplicationId applicationId) NN_NOEXCEPT;
void ClearApplicationId() NN_NOEXCEPT;

void AddResultBacktrace(erpt::Context* pOutValue, const ResultBacktrace& resultBacktrace) NN_NOEXCEPT;

}}}
