﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/erpt/server/erpt_ServerTypes.h>

#include "erptsrv_Allocator.h"
#include "erptsrv_Stream.h"
#include "erptsrv_Journal.h"

namespace nn   {
namespace erpt {
namespace srv  {

enum ReportOpenType
{
    ReportOpenType_Create,
    ReportOpenType_Read
};

const uint32_t ReportStreamBufferSize = 1024;

class Report :
    public Allocator,
    public Stream
{
private:
    JournalRecord* m_pRecord;

    ReportFileName FileName()
    NN_NOEXCEPT;

public:

    static ReportFileName FileName(ReportId reportId)
    NN_NOEXCEPT;

    nn::Result SetFlags(ReportFlagSet flagsIn)
    NN_NOEXCEPT;

    nn::Result GetFlags(ReportFlagSet* pFlagsOut)
    NN_NOEXCEPT;

    nn::Result GetSize(int64_t* size)
    NN_NOEXCEPT;

    char* GetName()
    NN_NOEXCEPT;

    nn::Result Open(ReportOpenType openType)
    NN_NOEXCEPT;

    template <typename T>
    nn::Result Write(T dataOut)
    NN_NOEXCEPT
    {
        return WriteStream(reinterpret_cast<const uint8_t*>(&dataOut), sizeof(dataOut));
    }

    template <typename T>
    nn::Result Write(T * pBufferOut, uint32_t bufferLength)
    NN_NOEXCEPT
    {
        return WriteStream(reinterpret_cast<const uint8_t*>(pBufferOut), bufferLength);
    }

    nn::Result Read(uint32_t* pBytesRead, uint8_t* pBufferIn, uint32_t bufferLength)
    NN_NOEXCEPT;

    nn::Result Delete()
    NN_NOEXCEPT;

    void Close()
    NN_NOEXCEPT;

    explicit Report(JournalRecord* pRecord)
    NN_NOEXCEPT;

    ~Report()
    NN_NOEXCEPT;
};

}}}
