﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/erpt/erpt_Result.h>
#include "erptsrv_ISession.h"
#include "erptsrv_IManager.h"
#include "erptsrv_IReport.h"

namespace nn   {
namespace erpt {
namespace srv  {

extern nn::sf::ExpHeapAllocator g_ServiceFrameworkAllocator;

nn::Result ISession::OpenReport(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IReport>> pReportOut)
NN_NOEXCEPT
{
    auto pInterface = nn::sf::ObjectFactory<
                           nn::sf::ExpHeapAllocator::Policy
                          >::CreateSharedEmplaced<
                           nn::erpt::sf::IReport,
                           nn::erpt::srv::IReport
                          >(&g_ServiceFrameworkAllocator);

    if (pInterface != nullptr)
    {
        pReportOut.Set(pInterface);
        return ResultSuccess();
    }

    return nn::erpt::ResultOutOfMemory();
}

nn::Result ISession::OpenManager(nn::sf::Out<nn::sf::SharedPointer<nn::erpt::sf::IManager>> pManagerOut)
NN_NOEXCEPT
{
    auto pInterface = nn::sf::ObjectFactory<
                           nn::sf::ExpHeapAllocator::Policy
                          >::CreateSharedEmplaced<
                           nn::erpt::sf::IManager,
                           nn::erpt::srv::IManager
                          >(&g_ServiceFrameworkAllocator);

    if (pInterface != nullptr)
    {
        pManagerOut.Set(pInterface);
        return ResultSuccess();
    }

    return nn::erpt::ResultOutOfMemory();
}

}}}
