﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/erpt/sfdl/erpt.sfdl.h>
#include <nn/erpt/server/erpt_ServerTypes.h>

namespace nn   {
namespace erpt {
namespace srv  {

class Report;

class IReport :
    public nn::sf::ISharedObject
{
private:
    Report* m_pReport;

public:
    nn::Result Open(ReportId reportId)
    NN_NOEXCEPT;

    nn::Result Read(nn::sf::Out<uint32_t> readCountOut, const nn::sf::OutBuffer& readBuffer)
    NN_NOEXCEPT;

    nn::Result SetFlags(ReportFlagSet flagsIn)
    NN_NOEXCEPT;

    nn::Result GetFlags(nn::sf::Out<ReportFlagSet> flagsOut)
    NN_NOEXCEPT;

    nn::Result Close()
    NN_NOEXCEPT;

    nn::Result GetSize(nn::sf::Out<int64_t> sizeOut)
    NN_NOEXCEPT;

    IReport()
    NN_NOEXCEPT;

    ~IReport()
    NN_NOEXCEPT;
};

}}}
