﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/erpt/erpt_Result.h>
#include <nn/erpt/sfdl/erpt.sfdl.h>
#include <nn/erpt/server/erpt_ServerTypes.h>

namespace nn   {
namespace erpt {
namespace srv  {

class IContext : public nn::sf::ISharedObject
{

public:
    nn::Result SubmitContext(
        const nn::sf::InBuffer& contextBufferIn,
        const nn::sf::InBuffer& dataBufferIn)
    NN_NOEXCEPT;

    nn::Result CreateReport(
        ReportType              type,
        const nn::sf::InBuffer& contextBufferIn,
        const nn::sf::InBuffer& dataBufferIn,
        const nn::sf::InBuffer& metaBufferIn)
    NN_NOEXCEPT;

    nn::Result SetInitialLaunchSettingsCompletionTime(
        const nn::time::SteadyClockTimePoint& timePoint
    )
    NN_NOEXCEPT;

    nn::Result ClearInitialLaunchSettingsCompletionTime()
    NN_NOEXCEPT;

    nn::Result UpdatePowerOnTime()
    NN_NOEXCEPT;

    nn::Result UpdateAwakeTime()
    NN_NOEXCEPT;

    nn::Result SubmitMultipleCategoryContext(
        const nn::erpt::MultipleCategoryContextEntry& contextEntryIn,
        const nn::sf::InBuffer& stringsBufferIn)
    NN_NOEXCEPT;

    IContext()
    NN_NOEXCEPT;
};

}}}
