﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nim/detail/nim_ServiceName.h>
#include <nn/os/os_Mutex.h>
#include <nn/sf/sf_ProxyObjectAllocator.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ObjectFactory.h>
#include "ec_ShopServiceObject.h"

namespace nn { namespace ec { namespace system {
    namespace {
        sf::ProxyObjectAllocator<16> g_ServiceObjectAllocator = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER;
        os::Mutex g_Mutex(false);
        sf::SharedPointer<nim::detail::IShopServiceManager> g_Proxy;
    }

    nim::detail::IShopServiceManager& GetShopServiceObject() NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(g_Mutex);
        if (!g_Proxy)
        {
            g_ServiceObjectAllocator.Initialize();
            NN_ABORT_UNLESS_RESULT_SUCCESS(sf::CreateHipcProxyByName<nim::detail::IShopServiceManager>(
                &g_Proxy, g_ServiceObjectAllocator.GetMemoryResource(), nim::detail::ServiceNameShop));
        }

        return *g_Proxy.Get();
    }

    void SetShopServiceObject(sf::SharedPointer<nim::detail::IShopServiceManager> p)
    {
        std::lock_guard<os::Mutex> guard(g_Mutex);
        g_Proxy = p;
    }
}}}
