﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/system/ec_DeviceLinkApi.h>
#include <nn/ec/system/ec_DeviceLinkSystemApi.h>
#include <nn/ec/ec_Result.h>
#include <nn/nifm/nifm_ApiClientManagement.h>

#include "ec_ResultUtil.h"
#include "ec_ShopServiceObject.h"

namespace nn { namespace ec { namespace system {
    Result RequestUnlinkDevice(AsyncResult* outValue, account::NintendoAccountId naUserId) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestUnlinkDevice(&nativeHandle, &sp, naUserId));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestCreateVirtualAccount(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());
        NN_RESULT_DO(RequestCreateVirtualAccountPrivate(outValue, uid));

        NN_RESULT_SUCCESS;
    }

    Result RequestLinkDevice(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());
        NN_RESULT_DO(RequestLinkDevicePrivate(outValue, uid));

        NN_RESULT_SUCCESS;
    }

    Result RequestUnlinkDevice(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());
        NN_RESULT_DO(RequestUnlinkDevicePrivate(outValue, uid));

        NN_RESULT_SUCCESS;
    }

    Result RequestUnlinkDeviceAll(AsyncResult* outValue) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());
        NN_RESULT_DO(RequestUnlinkDeviceAllPrivate(outValue));

        NN_RESULT_SUCCESS;
    }

    Result RequestDeviceLinkStatus(AsyncDeviceLinkStatus* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());
        NN_RESULT_DO(RequestDeviceLinkStatusPrivate(outValue, uid));

        NN_RESULT_SUCCESS;
    }

    bool HasDeviceLink(const account::Uid& uid) NN_NOEXCEPT
    {
        bool has;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetShopServiceObject().HasDeviceLink(&has, uid));

        return has;
    }

    Result RequestCreateVirtualAccountPrivate(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestCreateVirtualAccount(&nativeHandle, &sp, uid));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestLinkDevicePrivate(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestLinkDevice(&nativeHandle, &sp, uid));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestUnlinkDevicePrivate(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestUnlinkDeviceIntegrated(&nativeHandle, &sp, uid));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestUnlinkDeviceAllPrivate(AsyncResult* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestUnlinkDeviceAll(&nativeHandle, &sp));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestDeviceLinkStatusPrivate(AsyncDeviceLinkStatus* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncValue> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestDeviceLinkStatus(&nativeHandle, &sp, uid));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }
}}}
