﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <memory>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ec { namespace json {

//! 内部でメモリ割り当てを行わない出力ストリーム
class NoAllocationOutputStream
{
    NN_DISALLOW_COPY(NoAllocationOutputStream);
    NN_DISALLOW_MOVE(NoAllocationOutputStream);

public:
    typedef char Ch;

private:
    Ch* m_Buffer;
    size_t m_BufferSize;
    size_t m_FilledSize;

public:
    NoAllocationOutputStream() NN_NOEXCEPT
        : m_Buffer(nullptr)
        , m_BufferSize(0u)
        , m_FilledSize(0u)
    {
    }
    ~NoAllocationOutputStream() NN_NOEXCEPT {} // default

    void SetStringBuffer(Ch* buffer, size_t bufferSize) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(buffer != nullptr && bufferSize > 0u);
        NN_SDK_ASSERT(reinterpret_cast<uintptr_t>(buffer) % NN_ALIGNOF(Ch) == 0);
        NN_SDK_ASSERT(bufferSize % sizeof(Ch) == 0);
        m_Buffer = buffer;
        m_BufferSize = bufferSize;
    }

    Ch* GetBufferAddress() NN_NOEXCEPT
    {
        return m_Buffer;
    }

    size_t GetFilledSize() NN_NOEXCEPT
    {
        return m_FilledSize;
    }

    void Put(Ch c) NN_NOEXCEPT
    {
        if (m_FilledSize >= m_BufferSize)
        {
            NN_SDK_ASSERT(m_FilledSize == m_BufferSize);
            return;
        }
        m_Buffer[m_FilledSize ++] = c;
    }

    void Flush() NN_NOEXCEPT {}

};

}}} //! namespace nn::ec::json
