﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/http/json/http_JsonPath.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ec { namespace json { namespace adaptor {

//! Adaptor に必要な関数を全て定義する
template<int Depth, int Length>
class AdaptorBase
{
public:
    typedef nn::http::json::JsonPath<Depth, Length, false> JsonPathType;

    AdaptorBase() NN_NOEXCEPT : m_LastResult(ResultSuccess())
    {}

    void Update(const JsonPathType& jsonPath, std::nullptr_t n) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = UpdateImpl(jsonPath, n);
        }
    }
    void Update(const JsonPathType& jsonPath, bool value) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, uint64_t value) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, double value) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = UpdateImpl(jsonPath, value);
        }
    }
    void Update(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = UpdateImpl(jsonPath, value, valueLength);
        }
    }
    void NotifyObjectBegin(const JsonPathType& jsonPath) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = NotifyObjectBeginImpl(jsonPath);
        }
    }
    void NotifyObjectEnd(const JsonPathType& jsonPath) NN_NOEXCEPT
    {
        if (m_LastResult.IsSuccess())
        {
            m_LastResult = NotifyObjectEndImpl(jsonPath);
        }
    }
    virtual Result UpdateImpl(const JsonPathType&, std::nullptr_t) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
    virtual Result UpdateImpl(const JsonPathType&, bool) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
    virtual Result UpdateImpl(const JsonPathType&, int64_t) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
    virtual Result UpdateImpl(const JsonPathType&, uint64_t) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
    virtual Result UpdateImpl(const JsonPathType&, double) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
    virtual Result UpdateImpl(const JsonPathType&, const char*, int) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
    virtual Result NotifyObjectBeginImpl(const JsonPathType&) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
    virtual Result NotifyObjectEndImpl(const JsonPathType&) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    Result GetLastResult() NN_NOEXCEPT
    {
        return m_LastResult;
    }

private:
    Result m_LastResult;
};

}}}} //! namespace nn::ec::srv::adaptor
