﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.os
{
    [CppRefPath(@"<nn/os/os_Types.h>")]
    public struct ProcessId
    {
        public nn.Bit64 value;
    }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }
}

namespace nn.svc
{
    [CppRefPath(@"<nn/svc/svc_Handle.h>")]
    public struct Handle
    {
        public nn.Bit32 value;
    }
}

namespace nn.dbg
{
    [CppRefPath(@"<nn/dbg/dbg_Types.h>")]
    [ExternalStruct(48,8)]
    public struct ModuleInfo
    {
    }
}

namespace nn.dmnt
{
    namespace detail
    {
        public interface IInterface : IServiceObject
        {
            [MethodId(0)]
            Result
                BreakDebugProcess(
                    nn.svc.Handle           debug
                );

            [MethodId(1)]
            Result
                TerminateDebugProcess(
                    nn.svc.Handle           debug
                );

            [MethodId(2)]
            Result
                CloseHandle(
                    nn.svc.Handle           debug
                );

            [MethodId(3)]
            Result
                LoadImage(
                    Out<uint32_t>           pOutHandle,
                    InBuffer                FileName,
                    InBuffer                Args
                );

            [MethodId(4)]
            Result
                GetProcessId(
                    Out<nn.Bit64>           outPid,
                    nn.svc.Handle           process
                );

            [MethodId(5)]
            Result
                GetProcessHandle(
                    Out<uint32_t>           pOutHandle,
                    nn.Bit64                pid
                );


            [MethodId(6)]
            Result
                WaitSynchronization(
                    nn.svc.Handle           handle,
                    nn.Bit64                ns
                );

            [MethodId(7)]
            Result
                GetDebugEvent(
                    OutBuffer               pEvent,
                    nn.svc.Handle           process
                );

            [MethodId(8)]
            Result
                GetProcessModuleInfo(
                    Out<int32_t>            pOutCount,
                    OutBuffer               pOutModules,
                    int                     num,
                    nn.os.ProcessId         pid
                );

            [MethodId(9)]
            Result
                GetProcessList(
                    Out<int32_t>            pNumThreads,
                    OutBuffer               outProcessIds
                );

            [MethodId(10)]
            Result
                GetThreadList(
                    Out<int32_t>            pNumThreads,
                    OutBuffer               outThreads,
                    nn.svc.Handle           domain
                );

            [MethodId(11)]
            Result
                GetDebugThreadContext(
                    OutBuffer               outContext,
                    nn.svc.Handle           debug,
                    nn.Bit64                threadId,
                    nn.Bit32                controlFlags
                );

            [MethodId(12)]
            Result
                ContinueDebugEvent(
                    nn.svc.Handle           debug,
                    nn.Bit32                flags,
                    InBuffer                threadIds,
                    nn.Bit32                size
                );

            [MethodId(13)]
            Result
                ReadDebugProcessMemory(
                    OutBuffer               buf,
                    nn.svc.Handle           debug,
                    int64_t                 addr,
                    int64_t                 size
                );

            [MethodId(14)]
            Result
                WriteDebugProcessMemory(
                    nn.svc.Handle           debug,
                    InBuffer                buf,
                    int64_t                 addr,
                    int64_t                 size
                );

            [MethodId(15)]
            Result
                SetDebugThreadContext(
                    nn.svc.Handle           debug,
                    nn.Bit64                threadId,
                    InBuffer                context,
                    nn.Bit32                controlFlags
                );

            [MethodId(16)]
            Result
                GetDebugThreadParam(
                    Out<nn.Bit64>           pOut1,
                    Out<nn.Bit32>           pOut2,
                    nn.svc.Handle           debug,
                    nn.Bit64                threadId,
                    uint32_t                select
                );

            [MethodId(17)]
            Result
                InitializeThreadInfo(
                    OutBuffer               threadInfo,
                    nn.svc.Handle           debug,
                    InBuffer                createProcess,
                    InBuffer                createThread
                );

            [MethodId(18)]
            Result
                SetHardwareBreakPoint(
                    //nn.svc.HardwareBreakPointRegisterName regNo,
                    uint32_t                regNo,
                    nn.Bit64                control,
                    nn.Bit64                value
                );

            [MethodId(19)]
            Result
                QueryDebugProcessMemory(
                    OutBuffer               blockInfo,
                    OutBuffer               pageInfo,
                    nn.svc.Handle           debug,
                    int64_t                 addr
                );

            [MethodId(20)]
            Result
                GetProcessMemoryDetails(
                    Out<int32_t>            pNumMemoryBlocks,
                    OutBuffer               outData,
                    nn.svc.Handle           debug
                );

            [MethodId(21)]
            Result
                AttachByProgramId(
                    Out<uint32_t>           pOutHandle,
                    Out<nn.Bit64>           pPID,
                    nn.Bit64                processId
                );

            [MethodId(22)]
            Result
                AttachOnLaunch(
                    Out<uint32_t>           pOutHandle,
                    Out<nn.Bit64>           pPID,
                    nn.Bit64                processId
                );

            [MethodId(23)]
            Result
                GetDebugMonitorProcessId(
                    Out<nn.Bit64>           outPid
                );

            [MethodId( 25 )]
            Result
                GetJitDebugProcessList(
                    Out<int32_t>            pNumProcesses,
                    OutBuffer               outData
                );

            [MethodId( 26 )]
            Result
                CreateCoreDump(
                    InBuffer                FileName,
                    InBuffer                Details,
                    InBuffer                Modules,
                    InBuffer                Threads,
                    nn.svc.Handle           Handle
                );

            [MethodId( 27 )]
            Result
                GetAllDebugThreadInfo(
                    nn.svc.Handle           debug,
                    OutBuffer               outData,
                    InBuffer                threadInfo,
                    nn.Bit32                arraySize
                );

            [MethodId( 29 )]
            Result
                TargetIO_FileOpen(
                    InBuffer                FileName,
                    uint32_t                OpenMode,
                    int32_t                 CreationDisposition,
                    OutBuffer               pHandle
                );

            [MethodId( 30 )]
            Result
                TargetIO_FileClose(
                    InBuffer                Handle
                );

            [MethodId( 31 )]
            Result
                TargetIO_FileRead(
                    InBuffer                Handle,
                    OutBuffer               pBuffer,
                    Out<int32_t>            pNumberOfBytesRead,
                    int64_t                 Offset
                );

            [MethodId( 32 )]
            Result
                TargetIO_FileWrite(
                    InBuffer                Handle,
                    InBuffer                pBuffer,
                    Out<int32_t>            pNumberOfBytesWritten,
                    int64_t                 Offset
                );

            [MethodId( 33 )]
            Result
                TargetIO_FileSetAttributes(
                    InBuffer                FileName,
                    InBuffer                pAttribs
                );


            [MethodId( 34 )]
            Result
                TargetIO_FileGetInformation(
                    InBuffer                FileName,
                    Out<int32_t>            pIsDirectory,
                    OutBuffer               pData
                );

            [MethodId( 35 )]
            Result
                TargetIO_FileSetTime(
                    InBuffer                FileName,
                    uint64_t                CreateTime,
                    uint64_t                AccessTime,
                    uint64_t                ModifyTime
                );

            [MethodId( 36 )]
            Result
                TargetIO_FileSetSize(
                    InBuffer                FileName,
                    int64_t                 Size
                );

            [MethodId( 37 )]
            Result
                TargetIO_FileDelete(
                    InBuffer                FileName
                );

            [MethodId( 38 )]
            Result
                TargetIO_FileMove(
                    InBuffer                FromName,
                    InBuffer                ToName
                );

            [MethodId( 39 )]
            Result
                TargetIO_DirectoryCreate(
                    InBuffer                FileName
                );

            [MethodId( 40 )]
            Result
                TargetIO_DirectoryDelete(
                    InBuffer                FileName
                );

            [MethodId( 41 )]
            Result
                TargetIO_DirectoryRename(
                    InBuffer                FromName,
                    InBuffer                ToName
                );

            [MethodId( 42 )]
            Result
                TargetIO_DirectoryGetCount(
                    InBuffer                DirectoryName,
                    Out<int32_t>            pNumberOfEntries
                );

            [MethodId( 43 )]
            Result
                TargetIO_DirectoryOpen(
                    InBuffer                DirectoryName,
                    OutBuffer               pHandle
                );

            [MethodId( 44 )]
            Result
                TargetIO_DirectoryGetNext(
                    InBuffer                Handle,
                    OutBuffer               pEntry
                );

            [MethodId( 45 )]
            Result
                TargetIO_DirectoryClose(
                    InBuffer                Handle
                );

            [MethodId( 46 )]
            Result
                TargetIO_GetFreeSpace(
                    OutBuffer               pFreeSpace
                );

            [MethodId( 47 )]
            Result
                TargetIO_GetVolumeInformation(
                    OutBuffer               pVolumeName,
                    OutBuffer               pFileSystemName,
                    Out<int32_t>            pVolumeSerialNumber,
                    Out<int32_t>            pMaximumComponentLength,
                    Out<int32_t>            pFileSystemFlags
                );

            [MethodId( 48 )]
            Result
                InitiateCoreDump(
                    InBuffer        FileName,
                    InBuffer        Details,
                    InBuffer        Modules,
                    InBuffer        Threads,
                    nn.svc.Handle   Handle,
                    Out<uint64_t>   pDumpHandle
                );

            [MethodId( 49 )]
            Result
                ContinueCoreDump(
                    uint64_t        DumpHandle,
                    Out<int32_t>    pProgress
                );


            [MethodId( 50 )]
            Result
                AddTTYToCoreDump(
                    InBuffer        Data,
                    uint64_t        DumpHandle
                );

            [MethodId( 51 )]
            Result
                AddImageToCoreDump(
                    InBuffer        Data,
                    uint64_t        DumpHandle
                );

            [MethodId( 52 )]
            Result
                CloseCoreDump(
                    uint64_t        DumpHandle
                );
        }
    }
}
