﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/diag_AbortObserver.h>
#include <nn/diag/diag_AbortObserverForSystem.h>
#include <nn/diag/diag_AbortTypesForSystem.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>
#include <nn/fatal/fatal_ApiPrivate.h>

namespace nn { namespace diag {
    namespace {
        SdkAbortObserverHolder g_AbortObserverHolder;

        void SystemProcessDefaultAbortObserver(const SdkAbortInfo& abortInfo)
        {
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
            nn::fatal::ThrowFatal(abortInfo.result, abortInfo.userExceptionInfo);
#else
            NN_UNUSED(abortInfo);
#endif
        }
    } // namespace

void InitializeSystemProcessAbortObserver() NN_NOEXCEPT
{
    InitializeSdkAbortObserverHolder(&g_AbortObserverHolder, SystemProcessDefaultAbortObserver);
    RegisterSdkAbortObserver(&g_AbortObserverHolder);
}

}}
