﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "dhcps_Utils.h"

//#define NN_DETAIL_DHCPS_LOG_LEVEL NN_DETAIL_DHCPS_LOG_LEVEL_DEBUG
#define NN_DETAIL_DHCPS_LOG_MODULE_NAME "Utils"
#include "dhcps_Log.h"

namespace nn { namespace dhcps { namespace detail {

extern Config g_Config;

namespace {

/**
 * @brief This variable is the internal lock that guards private access into the API.
 */
nn::os::Mutex g_InternalLock(true);

/**
 * @brief This variable is the external lock that guards public access into the API.
 */
nn::os::Mutex g_ApiLock(true);

}; // end anonymous namespace


const char* MacAddressToString(char* dst, size_t size, const EthernetMacAddress pointer) NN_NOEXCEPT
{
    nn::util::SNPrintf(dst, size, "%02x:%02x:%02x:%02x:%02x:%02x",
                       pointer[0], pointer[1], pointer[2],
                       pointer[3], pointer[4], pointer[5]);
    return dst;
};

uint32_t Time() NN_NOEXCEPT
{
    return static_cast<uint32_t>(ConvertToTimeSpan(nn::os::GetSystemTick()).GetSeconds());
};

uint32_t RelativeTime(uint32_t now, uint32_t then) NN_NOEXCEPT
{
    int rc = 0;

    if (then > now)
    {
        rc = then - now;
    };

    return rc;
};

void ApiLock() NN_NOEXCEPT
{
    g_ApiLock.Lock();
};

void ApiUnlock() NN_NOEXCEPT
{
    g_ApiLock.Unlock();
};

void InternalLock() NN_NOEXCEPT
{
    g_InternalLock.Lock();
};

void InternalUnlock() NN_NOEXCEPT
{
    g_InternalLock.Unlock();
};

}}}; // nn::dhcps::detail
