﻿using System;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.dauth.detail
{
    internal static class PathInfo
    {
        public const string Prefix = "<";
        public const string Postfix = ">";
        public const string Root = @"nn/dauth/detail";
        public const string Path = Prefix + Root + @"/dauth_Interface.sfdl.h" + Postfix;
    }

    [Serializable]
    [AttributeUsage(AttributeTargets.Parameter, AllowMultiple = true)]
    public class NotNullAttribute : PreAttribute
    {
        public NotNullAttribute()
            : base("_.GetPointerUnsafe() != nullptr && _.GetSize() > 0")
        {
        }
    }

    public interface IAsyncResult
        : IServiceObject
    {
        [MethodId(0)]
        Result GetResult();

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result IsAvailable(Out<bool> pOut);

        [MethodId(3)]
        Result GetSystemEvent(Out<NativeHandle> pOutHandle);
    }

    [CppRefPath(PathInfo.Path)]
    public interface IService
        : IServiceObject
    {
        [MethodId(0)]
        Result EnsureAuthenticationTokenCacheAsync(Out<IAsyncResult> outAsync, UInt64 clientId, bool refresh);

        [MethodId(1)]
        Result LoadAuthenticationTokenCache(Out<Int64> outExpiration, [NotNull] OutBuffer buffer, UInt64 clientId);

        [MethodId(10)]
        Result EnsureEdgeTokenCacheAsync(Out<IAsyncResult> outAsync, UInt64 clientId);

        [MethodId(11)]
        Result LoadEdgeTokenCache(Out<Int64> outExpiration, [NotNull] OutBuffer buffer, UInt64 clientId);
    }
}
