﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "dauth_AsyncResultImpl.h"

#include <nn/dauth/detail/dauth_Result.h>
#include <nn/dauth/dauth_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace dauth { namespace detail {

Result AsyncResultImplBase::Initialize(util::Executable& executable, util::AbstractExecutor& executor) NN_NOEXCEPT
{
    NN_SDK_ASSERT(!m_pAsyncExecution);
    util::optional<util::AsyncExecution> pObj(util::in_place, &executable);
    NN_RESULT_DO(pObj->Initialize(&executor));
    m_pAsyncExecution = std::move(pObj);
    m_pExecutable = &executable;
    NN_RESULT_SUCCESS;
}
void AsyncResultImplBase::Finalize() NN_NOEXCEPT
{
    if (m_pAsyncExecution)
    {
        m_pAsyncExecution = util::nullopt;
    }
}
Result AsyncResultImplBase::GetResult() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_pAsyncExecution);
    NN_RESULT_THROW_UNLESS(m_pExecutable->HasDone(), detail::ResultInvalidProtocolAccess());
    auto pR = m_pExecutable->TryGetResult();
    return pR ? *pR : ResultCancelled();
}
Result AsyncResultImplBase::Cancel() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_pAsyncExecution);
    m_pAsyncExecution->Cancel();
    NN_RESULT_SUCCESS;
}
Result AsyncResultImplBase::IsAvailable(sf::Out<bool> pOut) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_pAsyncExecution);
    *pOut = m_pExecutable->HasDone();
    NN_RESULT_SUCCESS;
}
Result AsyncResultImplBase::GetSystemEvent(sf::Out<sf::NativeHandle> pOutHandle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_pAsyncExecution);
    *pOutHandle = sf::NativeHandle(m_pExecutable->GetReadableHandle(), false);
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::dauth::detail
