﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.codec.detail
{
    [CppRefPath("<nn/codec/detail/codec_HardwareOpusDecoderTypesInternal.h>")]
    public struct HardwareOpusDecoderParameterInternal
    {
        public int_t sampleRate;
        public int_t channelCount;
    }

    [CppRefPath("<nn/codec/detail/codec_HardwareOpusMultiStreamDecoderTypesInternal.h>")]
    [LargeData(true)]
    public struct HardwareOpusMultiStreamDecoderParameterInternal
    {
        public int_t sampleRate;
        public int_t channelCount;
        public int_t totalStreamCount;
        public int_t stereoStreamCount;
        [FixedArray(256)]
        public uint8_t[] channelMapping;
    }

    [CppRefPath(@"<nn/codec/detail/codec_IHardwareOpusDecoder.h>")]
    public interface IHardwareOpusDecoder : IServiceObject
    {
        [MethodId(0)]
        // OpusResult DecodeInterleaved(size_t* pOutConsumed, int* pOutSampleCount, int16_t* outputBuffer, size_t outputSize, const void* inputBuffer, size_t inputSize) NN_NOEXCEPT = 0;
        Result DecodeInterleavedOld( Out<int_t> pOutConsumed, Out<int_t> pOutSampleCount, nn.sf.OutBuffer outputBuffer, nn.sf.InBuffer inputBuffer );

        [MethodId(1)]
        // OpusResult SetContext(const void* pContext, size_t size) NN_NOEXCEPT = 0;
        Result SetContext( nn.sf.InBuffer pContext );

        [MethodId(2)]
        // OpusResult DecodeInterleaved(size_t* pOutConsumed, int* pOutSampleCount, int16_t* outputBuffer, size_t outputSize, const void* inputBuffer, size_t inputSize) NN_NOEXCEPT = 0;
        Result DecodeInterleavedForMultiStreamOld( Out<int_t> pOutConsumed, Out<int_t> pOutSampleCount, nn.sf.OutBuffer outputBuffer, nn.sf.InBuffer inputBuffer );

        [MethodId(3)]
        // OpusResult SetContext(const void* pContext, size_t size) NN_NOEXCEPT = 0;
        Result SetContextForMultiStream( nn.sf.InBuffer pContext );

        [MethodId(4)]
        Result DecodeInterleavedWithPerfOld( Out<int_t> pOutConsumed, Out<int64_t> pOutPerf, Out<int_t> pOutSampleCount, [NonSecureMapTransfer] nn.sf.OutBuffer outputBuffer, nn.sf.InBuffer inputBuffer );

        [MethodId(5)]
        Result DecodeInterleavedForMultiStreamWithPerfOld( Out<int_t> pOutConsumed, Out<int64_t> pOutPerf, Out<int_t> pOutSampleCount, [NonSecureMapTransfer] nn.sf.OutBuffer outputBuffer, nn.sf.InBuffer inputBuffer );

        [MethodId(6)]
        Result DecodeInterleaved( Out<int_t> pOutConsumed, Out<int64_t> pOutPerf, Out<int_t> pOutSampleCount, [NonSecureMapTransfer] nn.sf.OutBuffer outputBuffer, nn.sf.InBuffer inputBuffer, bool isResetRequested );

        [MethodId(7)]
        Result DecodeInterleavedForMultiStream( Out<int_t> pOutConsumed, Out<int64_t> pOutPerf, Out<int_t> pOutSampleCount, [NonSecureMapTransfer] nn.sf.OutBuffer outputBuffer, nn.sf.InBuffer inputBuffer, bool isResetRequested );
    }

    [CppRefPath(@"<nn/codec/detail/codec_IHardwareOpusDecoderManager.h>")]
    interface IHardwareOpusDecoderManager : IServiceObject
    {
        [MethodId(0)]
        // (de facto) OpusResult Initialize( void ) NN_NOEXCEPT;
        Result OpenHardwareOpusDecoder( Out<IHardwareOpusDecoder> outHardwareOpusDecoder, HardwareOpusDecoderParameterInternal parameter, NativeHandle handle, int_t size);

        [MethodId(1)]
        Result GetWorkBufferSize( Out<int_t> pBufferSize, HardwareOpusDecoderParameterInternal parameter );

        [MethodId(2)]
        Result OpenHardwareOpusDecoderForMultiStream( Out<IHardwareOpusDecoder> outHardwareOpusDecoder, HardwareOpusMultiStreamDecoderParameterInternal parameter, NativeHandle handle, int_t size);

        [MethodId(3)]
        Result GetWorkBufferSizeForMultiStream( Out<int_t> pBufferSize, HardwareOpusMultiStreamDecoderParameterInternal parameter );
    }
}
