﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if defined(_NX_CODEC_DSP_)
#include <lib/mailbox.h>
#undef NN_NOEXCEPT
#define NN_NOEXCEPT

#else  //
#include <nne/audio/audio.h>
#endif

namespace nn { namespace codec { namespace dsp {

class MboxWrapper
{
public:

    enum MailboxStatus {
        MailboxStatusNoError = 0
    };

    MboxWrapper() NN_NOEXCEPT
        : m_MailboxId(0),
          m_IsAvailable(false),
          m_LastStatus(MailboxStatusNoError)
    {}

    ~MboxWrapper() NN_NOEXCEPT
    {
        Close();
    }

    bool Open(int mailboxId) NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;

    bool SendData(int data, int64_t timeoutInMilli) NN_NOEXCEPT;
    bool ReceiveData(int* pData, int64_t timeoutInMilli) NN_NOEXCEPT;

    inline bool IsAvailable() const NN_NOEXCEPT { return m_IsAvailable; }
    inline int  GetMailboxId() const NN_NOEXCEPT { return m_MailboxId; }
    inline int  GetLastStatus() const NN_NOEXCEPT { return m_LastStatus; }

    int  GetLastError() NN_NOEXCEPT;

private:
#if defined(_NX_CODEC_DSP_)
    adsp_mbx_t m_Mailbox;
#else  // TARGET_CPU
    nne::audio::adsp::MboxType m_Mailbox;
#endif
    int16_t m_MailboxId;
    bool m_IsAvailable;
    int m_LastStatus;
};

}}} // nn::codec::dsp

