﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include <nn/codec/codec_OpusEncoderTypes.h>
#include <nn/codec/detail/codec_OpusEncoderTypesInternal.h>

struct OpusEncoder;
struct OpusDecoder;

namespace nn {
namespace codec {
namespace detail {

// opus_encoder_ctl 関連
void OpusEncoderControl(::OpusEncoder* pOpusEncoder, int request, ...) NN_NOEXCEPT;
void VerifyOpusEncoderControlValue(::OpusEncoder* pOpusEncoder, int correctValue, int getRequest) NN_NOEXCEPT;

// Get()
uint32_t GetFinalRangeInternal(::OpusEncoder* pOpusEncoder) NN_NOEXCEPT;
int GetLookAheadInternal(::OpusEncoder* pOpusEncoder) NN_NOEXCEPT;
int GetBitRateInternal(::OpusEncoder* pOpusEncoder) NN_NOEXCEPT;

// Set()
void SetBitRateInternal(::OpusEncoder* pOpusEncoder, int bitRate, int channelCount) NN_NOEXCEPT;
void SetBitRateControlInternal(::OpusEncoder* pOpusEncoder, OpusBitRateControl bitRateControl) NN_NOEXCEPT;
void SetBandwidthInternal(::OpusEncoder* pOpusEncoder, OpusBandwidth bandwidth) NN_NOEXCEPT;
void SetApplicationInternal(::OpusEncoder* pOpusEncoder, OpusApplication application) NN_NOEXCEPT;
void SetSignalInternal(::OpusEncoder* pOpusEncoder, OpusWaveformType waveformType) NN_NOEXCEPT;
void SetComplexityInternal(::OpusEncoder* pOpusEncoder, int complexity) NN_NOEXCEPT;
void SetLsbDepthInternal(::OpusEncoder* pOpusEncoder, int depth) NN_NOEXCEPT;
void SetFrameSizeTypeInternal(::OpusEncoder* pOpusEncoder, OpusFrameSize frameSize) NN_NOEXCEPT;
void SetForceModeInternal(::OpusEncoder* pOpusEncoder, OpusCodingMode codingMode) NN_NOEXCEPT;

// Converters
int  GetOpusApplicationValue(OpusApplication application) NN_NOEXCEPT;
int  GetOpusForceModeValue(OpusCodingMode forceMode) NN_NOEXCEPT;
int  GetOpusBandwidthValue(nn::codec::OpusBandwidth bandwidth) NN_NOEXCEPT;

}}}  // namespace nn::codec::detail
